/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.resource.loader.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3288;
import net.minecraft.class_3298;
import net.minecraft.class_3302;
import net.minecraft.class_3306;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.qsl.resource.loader.api.GroupResourcePack;
import org.quiltmc.qsl.resource.loader.api.ResourceLoader;
import org.quiltmc.qsl.resource.loader.api.ResourcePackActivationType;
import org.quiltmc.qsl.resource.loader.api.reloader.IdentifiableResourceReloader;
import org.quiltmc.qsl.resource.loader.impl.ModNioResourcePack;
import org.quiltmc.qsl.resource.loader.impl.QuiltBuiltinResourcePackProfile;
import org.quiltmc.qsl.resource.loader.mixin.NamespaceResourceManagerAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class ResourceLoaderImpl
implements ResourceLoader {
    private static final Map<class_3264, ResourceLoaderImpl> IMPL_MAP = new EnumMap<class_3264, ResourceLoaderImpl>(class_3264.class);
    private static final Map<String, ModNioResourcePack> CLIENT_BUILTIN_RESOURCE_PACKS = new Object2ObjectOpenHashMap();
    private static final Map<String, ModNioResourcePack> SERVER_BUILTIN_RESOURCE_PACKS = new Object2ObjectOpenHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ResourceLoader");
    private final Set<class_2960> addedListenerIds = new HashSet<class_2960>();
    private final Set<IdentifiableResourceReloader> addedReloaders = new LinkedHashSet<IdentifiableResourceReloader>();

    public static ResourceLoaderImpl get(class_3264 type) {
        return IMPL_MAP.computeIfAbsent(type, t -> new ResourceLoaderImpl());
    }

    public static void sort(class_3264 type, List<class_3302> reloaders) {
        ResourceLoaderImpl.get(type).sort(reloaders);
    }

    @Override
    public void registerReloader(IdentifiableResourceReloader resourceReloader) {
        if (!this.addedListenerIds.add(resourceReloader.getQuiltId())) {
            throw new IllegalStateException("Tried to register resource reloader " + resourceReloader.getQuiltId() + " twice!");
        }
        if (!this.addedReloaders.add(resourceReloader)) {
            throw new IllegalStateException("Resource reloader with previously unknown ID " + resourceReloader.getQuiltId() + " already in resource reloader set!");
        }
    }

    private void sort(List<class_3302> reloaders) {
        reloaders.removeAll(this.addedReloaders);
        ArrayList<IdentifiableResourceReloader> reloadersToAdd = new ArrayList<IdentifiableResourceReloader>(this.addedReloaders);
        HashSet<class_2960> resolvedIds = new HashSet<class_2960>();
        for (class_3302 reloader : reloaders) {
            if (!(reloader instanceof IdentifiableResourceReloader)) continue;
            IdentifiableResourceReloader identifiableResourceReloader = (IdentifiableResourceReloader)reloader;
            resolvedIds.add(identifiableResourceReloader.getQuiltId());
        }
        int lastSize = -1;
        while (reloaders.size() != lastSize) {
            lastSize = reloaders.size();
            Iterator<IdentifiableResourceReloader> it = reloadersToAdd.iterator();
            while (it.hasNext()) {
                IdentifiableResourceReloader listener = it.next();
                if (!resolvedIds.containsAll(listener.getQuiltDependencies())) continue;
                resolvedIds.add(listener.getQuiltId());
                reloaders.add(listener);
                it.remove();
            }
        }
        for (IdentifiableResourceReloader reloader : reloadersToAdd) {
            LOGGER.warn("Could not resolve dependencies for resource reloader: " + reloader.getQuiltId() + "!");
        }
    }

    private static Path locateDefaultResourcePack(class_3264 type) {
        try {
            URL assetsRootUrl = class_3268.class.getResource("/" + type.method_14413() + "/.mcassetsroot");
            return Paths.get(assetsRootUrl.toURI()).resolve("../..").toAbsolutePath().normalize();
        }
        catch (Exception exception) {
            throw new RuntimeException("Quilt: Failed to locate Minecraft assets root!", exception);
        }
    }

    public static ModNioResourcePack locateAndLoadDefaultResourcePack(class_3264 type) {
        return ModNioResourcePack.ofMod(FabricLoader.getInstance().getModContainer("minecraft").map(ModContainer::getMetadata).orElseThrow(), ResourceLoaderImpl.locateDefaultResourcePack(type), type, "Default");
    }

    public static void appendModResourcePacks(List<class_3262> packs, class_3264 type, @Nullable String subPath) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModNioResourcePack pack;
            if (container.getMetadata().getType().equals("builtin")) continue;
            Path path = container.getRootPath();
            if (subPath != null) {
                Path childPath = path.resolve(subPath.replace("/", path.getFileSystem().getSeparator())).toAbsolutePath().normalize();
                if (!childPath.startsWith(path) || !Files.exists(childPath, new LinkOption[0])) continue;
                path = childPath;
            }
            if ((pack = ModNioResourcePack.ofMod(container.getMetadata(), path, type, null)).method_14406(type).isEmpty()) continue;
            packs.add((class_3262)pack);
        }
    }

    public static GroupResourcePack.Wrapped buildMinecraftResourcePack(class_3268 vanillaPack) {
        class_3264 type = vanillaPack.getClass().equals(class_3268.class) ? class_3264.field_14190 : class_3264.field_14188;
        ArrayList<class_3262> packs = new ArrayList<class_3262>();
        ResourceLoaderImpl.appendModResourcePacks(packs, type, null);
        return new GroupResourcePack.Wrapped(type, (class_3262)vanillaPack, packs, false);
    }

    public static GroupResourcePack.Wrapped buildProgrammerArtResourcePack(class_3255 vanillaPack) {
        ArrayList<class_3262> packs = new ArrayList<class_3262>();
        ResourceLoaderImpl.appendModResourcePacks(packs, class_3264.field_14188, "programmer_art");
        return new GroupResourcePack.Wrapped(class_3264.field_14188, (class_3262)vanillaPack, packs, true);
    }

    public static void appendResourcesFromGroup(NamespaceResourceManagerAccessor manager, class_2960 id, GroupResourcePack groupResourcePack, List<class_3298> resources) throws IOException {
        List<? extends class_3262> packs = groupResourcePack.getPacks(id.method_12836());
        if (packs == null) {
            return;
        }
        class_2960 metadataId = NamespaceResourceManagerAccessor.invokeGetMetadataPath(id);
        for (class_3262 class_32622 : packs) {
            if (!class_32622.method_14411(manager.getType(), id)) continue;
            InputStream metadataInputStream = class_32622.method_14411(manager.getType(), metadataId) ? manager.invokeOpen(metadataId, class_32622) : null;
            resources.add((class_3298)new class_3306(class_32622.method_14409(), id, manager.invokeOpen(id, class_32622), metadataInputStream));
        }
    }

    public static class_2561 getBuiltinPackDisplayNameFromId(class_2960 id) {
        return new class_2585(id.method_12836() + "/" + id.method_12832());
    }

    public static boolean registerBuiltinResourcePack(class_2960 id, String subPath, ModContainer container, ResourcePackActivationType activationType, class_2561 displayName) {
        String separator = container.getRootPath().getFileSystem().getSeparator();
        subPath = subPath.replace("/", separator);
        Path resourcePackPath = container.getRootPath().resolve(subPath).toAbsolutePath().normalize();
        if (!Files.exists(resourcePackPath, new LinkOption[0])) {
            return false;
        }
        String name = id.method_12836() + "/" + id.method_12832();
        boolean result = false;
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            result = ResourceLoaderImpl.registerBuiltinResourcePack(class_3264.field_14188, ResourceLoaderImpl.newBuiltinResourcePack(container, name, displayName, resourcePackPath, class_3264.field_14188, activationType));
        }
        return result |= ResourceLoaderImpl.registerBuiltinResourcePack(class_3264.field_14190, ResourceLoaderImpl.newBuiltinResourcePack(container, name, displayName, resourcePackPath, class_3264.field_14190, activationType));
    }

    private static boolean registerBuiltinResourcePack(class_3264 type, ModNioResourcePack pack) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment() || !pack.method_14406(type).isEmpty()) {
            Map<String, ModNioResourcePack> builtinResourcePacks = type == class_3264.field_14188 ? CLIENT_BUILTIN_RESOURCE_PACKS : SERVER_BUILTIN_RESOURCE_PACKS;
            builtinResourcePacks.put(pack.method_14409(), pack);
            return true;
        }
        return false;
    }

    private static ModNioResourcePack newBuiltinResourcePack(ModContainer container, String name, class_2561 displayName, Path resourcePackPath, class_3264 type, ResourcePackActivationType activationType) {
        return new ModNioResourcePack(name, container.getMetadata(), displayName, activationType, resourcePackPath, type, null);
    }

    public static void registerBuiltinResourcePacks(class_3264 type, Consumer<class_3288> profileAdder) {
        Map<String, ModNioResourcePack> builtinPacks = type == class_3264.field_14188 ? CLIENT_BUILTIN_RESOURCE_PACKS : SERVER_BUILTIN_RESOURCE_PACKS;
        for (Map.Entry<String, ModNioResourcePack> entry : builtinPacks.entrySet()) {
            QuiltBuiltinResourcePackProfile profile;
            ModNioResourcePack pack = entry.getValue();
            if (pack.method_14406(type).isEmpty() || (profile = QuiltBuiltinResourcePackProfile.of(pack)) == null) continue;
            profileAdder.accept(profile);
        }
    }
}

